// -------------------------------------------------------------
// variables that are provided by the application
// -------------------------------------------------------------
float4x4 g_view_projection_matrix;	
float4x4 g_world_matrix;	

texture g_tex0;
sampler OuterSky = sampler_state
{
   Texture = <g_tex0>;
   MinFilter = Linear;
   MagFilter = Linear;
   MipFilter = Linear;   
   //AddressU  = Clamp;
   //AddressV  = Clamp;
};

texture g_tex1;
sampler InnerSky = sampler_state
{
   Texture = <g_tex1>;
   MinFilter = Linear;
   MagFilter = Linear;
   MipFilter = Linear;   
   //AddressU  = Clamp;
   //AddressV  = Clamp;
};

// -------------------------------------------------------------
// Output channels
// -------------------------------------------------------------
struct VS_OUTPUT
{
    float4 Pos  : POSITION;
    float2 Tex : TEXCOORD0;
};

// -------------------------------------------------------------
// vertex shader function (input channels)
// -------------------------------------------------------------
VS_OUTPUT VS(float4 Pos : POSITION, float2 Tex : TEXCOORD, float3 Normal : NORMAL )
{
    VS_OUTPUT Out = (VS_OUTPUT)0;      
    Out.Pos = mul(Pos, g_world_matrix);	// transform Position
    Out.Pos = mul(Out.Pos, g_view_projection_matrix);
    
    Out.Tex = Tex;
    
   return Out;
}

// -------------------------------------------------------------
// Pixel Shader (input channels):output channel
// -------------------------------------------------------------
float4 PS( float2 Tex: TEXCOORD0 ) : COLOR
{
	float4 inner = tex2D(InnerSky, Tex);
	float4 outer = tex2D(OuterSky, Tex);
	inner.rgb = inner.rgb * inner.a;
	return float4(outer + inner );
	//return float4( tex2D(OuterSky, Tex) * tex2D(InnerSky, Tex) );
   // return tex2D(ColorMapSampler, Tex);	
}

// -------------------------------------------------------------
// 
// -------------------------------------------------------------
technique normal
{
    pass P0
    {
    cullmode = NONE;
        // compile shaders
        VertexShader = compile vs_1_1 VS();
        PixelShader  = compile ps_2_0 PS();
    }
}
